﻿<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet
    xmlns:ASFALIS="http://wwww.elysium.co.jp/2004/ASFALIS-NS/"
    xmlns:ASFALIS2006="http://www.elysium.co.jp/2006/ASFALIS-NS/"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  version="5.0">


    <xsl:output method="html"/>

<!-- ############################# ASFALIS ################################ -->
<!-- ###################################################################### -->
<!-- Root of this style sheet -->
    <xsl:template match="/ASFALIS:AsfalisLogList">
        <HTML>
        <HEAD>
            <TITLE>ASFALIS Adapter Log File</TITLE>
        </HEAD>

        <BODY>
        <H1>ASFALIS Adapter 実行ログ</H1>
        <xsl:for-each select="ASFALIS:AsfalisLog">
            <xsl:choose>
                <xsl:when test="@type='AUTOHEAL'"><H1>ENF Healer</H1></xsl:when>
                <xsl:when test="@type='CAD2ENF'"><H1>ENF Writer</H1></xsl:when>
                <xsl:when test="@type='ENF2CAD'"><H1>ENF Reader</H1></xsl:when>
                <xsl:when test="@type='PDQCHECK'"><H1>PDQ Checker</H1></xsl:when>
                <xsl:when test="@type='SIMPLIFY'"><H1>Geometry Simplifier</H1></xsl:when>
                <xsl:when test="@type='GEOMDIFF'"><H1>CAD Validator</H1></xsl:when>
                <xsl:when test="@type='ATTREDIT'"><H1>Attribute Editor</H1></xsl:when>
                <xsl:when test="@type='QFMCHECK'"><H1>QFM Checker</H1></xsl:when>
                <xsl:when test="@type='PLYGNOPTIMIZE'"><H1>Polygon Optimizer</H1></xsl:when>
                <xsl:when test="@type='POLYGON'"><H1>ENF Polygon</H1></xsl:when>
                <xsl:otherwise><H1>ASFALIS Adapter Family</H1></xsl:otherwise>
            </xsl:choose>

            <xsl:if test="@isPrimary='no'">
                (補助情報)
            </xsl:if>

            <xsl:apply-templates select="ASFALIS:ProcessInfo"/>
            <xsl:apply-templates select="ASFALIS:ModelInfoList"/>
            <xsl:apply-templates select="ASFALIS:AssemblyTreeInfo"/>
            <xsl:apply-templates select="ASFALIS:BodyInfoList"/>
            <xsl:apply-templates select="ASFALIS:ComponentInfoList"/>
            <HR/>
        </xsl:for-each>
        </BODY>
        </HTML>
    </xsl:template>



<!-- ###################################################################### -->

<!--
    Print information of overall process
  -->
    <xsl:template match="ASFALIS:ProcessInfo">
        <H2>概要</H2>
        <TABLE border="1">
            <TR>
                <TH>変換元</TH>
                <TD><xsl:value-of select="ASFALIS:OriginalCad/@name"/></TD>
                <TD><xsl:value-of select="ASFALIS:OriginalCad/@version"/></TD>
            </TR>
            <TR>
                <TH>変換先</TH>
                <TD><xsl:value-of select="ASFALIS:TargetCad/@name"/></TD>
                <TD><xsl:value-of select="ASFALIS:TargetCad/@version"/></TD>
            </TR>
            <TR>
                <TH>入力ファイル名</TH>
                <TD colspan="2"><xsl:value-of select="ASFALIS:InputFile/@fileName"/></TD>
            </TR>
            <TR>
                <TH>出力ファイル名</TH>
                <TD colspan="2"><xsl:value-of select="ASFALIS:OutputFile/@fileName"/></TD>
            </TR>
            <TR>
                <TH>開始時刻</TH>
                <TD colspan="2"><xsl:value-of select="ASFALIS:TimeInfo/@startTime"/></TD>
            </TR>
            <TR>
                <TH>終了時刻</TH>
                <TD colspan="2"><xsl:value-of select="ASFALIS:TimeInfo/@endTime"/></TD>
            </TR>
            <TR>
                <TH>所要時間</TH>
                <TD colspan="2"><xsl:value-of select="ASFALIS:TimeInfo/@duration"/></TD>
            </TR>
            <TR>
                <TH>プログラム</TH>
                <TD><xsl:value-of select="ASFALIS:ElysiumModule/@fileName"/></TD>
                <TD><xsl:value-of select="ASFALIS:ElysiumModule/@version"/></TD>
            </TR>
        </TABLE>

        <xsl:apply-templates select="ASFALIS:Errors"/>
        <xsl:call-template name="ASFALIS:ProcessDetailInfo"/>
    </xsl:template>

<!-- ###################################################################### -->
<!--
    Print information of model, (occurrence tree)
  -->
    <xsl:template match="ASFALIS:ModelInfoList">
        <HR/>
        <H2>アセンブリツリー</H2>
            <xsl:for-each select="ASFALIS:ModelInfo">
                <xsl:call-template name="ASFALIS:PrintModelInfo"/>
                <HR/>
            </xsl:for-each>
    </xsl:template>

    <xsl:template name="ASFALIS:PrintModelInfo">
        <xsl:for-each select="ASFALIS:ComponentRef">
            <xsl:call-template name="ASFALIS:PrintComponentRef"/>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="ASFALIS:PrintComponentRef">
        <xsl:for-each select="@dekId">
            [ID : <xsl:value-of select="."/>]  
        </xsl:for-each>
        <UL>
        <xsl:for-each select="ASFALIS:ComponentInstanceInfo">
            <LI><xsl:call-template name="ASFALIS:PrintComponentInstanceInfo"/></LI>
        </xsl:for-each>
        </UL>
    </xsl:template>

    <xsl:template name="ASFALIS:PrintComponentInstanceInfo">
        <xsl:for-each select="@instanceName">
            [<xsl:value-of select="."/>]  
        </xsl:for-each>
        <xsl:for-each select="ASFALIS:ComponentRef">
            <xsl:call-template name="ASFALIS:PrintComponentRef"/>
        </xsl:for-each>
     </xsl:template>


<!-- ###################################################################### -->
<!--
    Print information of assembly tree
  -->
    <xsl:template match="ASFALIS:AssemblyTreeInfo">
        <HR/>
        <H2>アセンブリツリー</H2>
        <UL>
        <xsl:for-each select="ASFALIS:AssemblyInfo">
            <LI><xsl:call-template name="ASFALIS:PrintAssemblyInfo"/></LI>
        </xsl:for-each>
        <xsl:for-each select="ASFALIS:BodyRef">
            <LI><xsl:call-template name="ASFALIS:PrintBodyRefInfo"/></LI>
        </xsl:for-each>
        </UL>
    </xsl:template>

<!--
    Print information of assembly
  -->
    <xsl:template name="ASFALIS:PrintAssemblyInfo">
        A  
        <xsl:for-each select="@assemblyName">
            [<xsl:value-of select="."/>]  
        </xsl:for-each>

        <xsl:for-each select="@assemblyDekId">
            [ID : <xsl:value-of select="."/>]  
        </xsl:for-each>

        <xsl:for-each select="@assemblyPartNumber">
            [Part Number = <xsl:value-of select="."/>]
        </xsl:for-each>
        <BR/>
        <UL>
            <xsl:for-each select="ASFALIS:InstanceInfo">
                <LI>
                    <xsl:call-template name="ASFALIS:PrintInstanceInfo"/>
                </LI>
            </xsl:for-each>
        </UL>
    </xsl:template>


<!--
    Print information of assembly instance
  -->
    <xsl:template name="ASFALIS:PrintInstanceInfo">
        I   
        <xsl:for-each select="@instanceName">
            [<xsl:value-of select="."/>]  
        </xsl:for-each>
        <xsl:for-each select="@instanceDekId">
            [ID : <xsl:value-of select="."/>]  
        </xsl:for-each>
        <BR/>
        <UL>
        <xsl:for-each select="ASFALIS:AssemblyInfo">
            <LI><xsl:call-template name="ASFALIS:PrintAssemblyInfo"/></LI>
        </xsl:for-each>
        <xsl:for-each select="ASFALIS:BodyRef">
            <LI><xsl:call-template name="ASFALIS:PrintBodyRefInfo"/></LI>
        </xsl:for-each>
        </UL>
     </xsl:template>


<!--
    Print information of body reference from assembly tree
  -->
    <xsl:template name="ASFALIS:PrintBodyRefInfo">
        B 
        <xsl:for-each select="@bodyName">
            [<xsl:value-of select="."/>]  
        </xsl:for-each>

        <xsl:for-each select="@bodyDekId">
            [ID : <xsl:value-of select="."/>]  
        </xsl:for-each>
    </xsl:template>


<!-- ###################################################################### -->
<!--
    Print information of each component
  -->
    <xsl:template match="ASFALIS:ComponentInfoList">
        <HR/>
        <H2>各Part,Assemblyの情報</H2>
            <xsl:for-each select="ASFALIS:ComponentInfo">
                <xsl:call-template name="ASFALIS:PrintComponentInfo"/>
                <HR/>
            </xsl:for-each>
    </xsl:template>

    <xsl:template name="ASFALIS:PrintComponentInfo">
        <TABLE border="1">
            <xsl:for-each select="@dekId">
                <TR>
                    <TH>Part ID (ENF)</TH><TH><xsl:value-of select="."/></TH>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@componentType">
                <TR>
                    <TH>Type</TH><TH><xsl:value-of select="."/></TH>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@componentName">
                <TR>
                    <TH>名前</TH><TH><xsl:value-of select="."/></TH>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@partName">
                <TR>
                    <TH>Part Name</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@partNumber">
                <TR>
                    <TH>Part Number</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>
            
            <xsl:for-each select="@nativeFilename">
                <TR>
                    <TH>元CADファイル名</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>

        </TABLE>

        <xsl:for-each select="ASFALIS:Representation">
            <xsl:call-template name="ASFALIS:PrintRepresentation"/>
        </xsl:for-each>
        
    </xsl:template>


    <xsl:template name="ASFALIS:PrintRepresentation">
        <xsl:for-each select="ASFALIS:Errors">
            <xsl:call-template name="ASFALIS:PrintErrors"/>
        </xsl:for-each>

        <xsl:for-each select="ASFALIS:MassProperties">
            <xsl:call-template name="ASFALIS:PrintMassProperties"/>
        </xsl:for-each>

        <xsl:for-each select="ASFALIS:EntityNumberSets">
            <xsl:call-template name="ASFALIS:PrintEntityNumberSets"/>
        </xsl:for-each>
    </xsl:template>

<!--
    Print information of each body
  -->
    <xsl:template match="ASFALIS:BodyInfoList">
        <HR/>
        <H2>各Partの情報</H2>
            <xsl:for-each select="ASFALIS:BodyInfo">
                <xsl:call-template name="ASFALIS:PrintBodyInfo"/>
                <HR/>
            </xsl:for-each>
    </xsl:template>

    <xsl:template name="ASFALIS:PrintBodyInfo">
        <TABLE border="1">
            <xsl:for-each select="@bodyDekId">
                <TR>
                    <TH>Part ID (ENF)</TH><TH><xsl:value-of select="."/></TH>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@bodyName">
                <TR>
                    <TH>名前</TH><TH><xsl:value-of select="."/></TH>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@partName">
                <TR>
                    <TH>Part Name</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@partNumber">
                <TR>
                    <TH>Part Number</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@nativeFilename">
                <TR>
                    <TH>元CADファイル名</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>
        </TABLE>

        <xsl:for-each select="ASFALIS:Errors">
            <xsl:call-template name="ASFALIS:PrintErrors"/>
        </xsl:for-each>

        <xsl:for-each select="ASFALIS:MassProperties">
            <xsl:call-template name="ASFALIS:PrintMassProperties"/>
        </xsl:for-each>

        <xsl:for-each select="ASFALIS:EntityNumberSets">
            <xsl:call-template name="ASFALIS:PrintEntityNumberSets"/>
        </xsl:for-each>
    </xsl:template>


<!-- ###################################################################### -->
    <!--
        Print error information
      -->
    <xsl:template match="ASFALIS:Errors">
        <xsl:call-template name="ASFALIS:PrintErrors"/>
    </xsl:template>

    <xsl:template name="ASFALIS:PrintErrors">
        <H4><FONT color="#FF0000">変換エラー</FONT></H4>
        <TABLE border="1">
            <TR>
                <TH>エラータイプ</TH>
                <TH>説明</TH>
            </TR>
            <xsl:for-each select="ASFALIS:Error">
                <TR>
                    <TD><xsl:value-of select="@errorType"/></TD>
                    <TD><xsl:value-of select="@description"/></TD>
                </TR>
            </xsl:for-each>
        </TABLE>
    </xsl:template>


    <!--
        Print detail information usefull for developers
      -->
    <xsl:template name="ASFALIS:ProcessDetailInfo">
        <HR/>
        <H2>詳細情報</H2>
        <TABLE border="1">
            <xsl:for-each select="ASFALIS:OS">
                <TR>
                    <TH>OS</TH>
                    <TD><xsl:value-of select="@name"/></TD>
                    <TD><xsl:value-of select="@version"/></TD>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="ASFALIS:CurrentDirectory">
                <TR>
                    <TH>実行ディレクトリ</TH>
                    <TD><xsl:value-of select="@pathName"/></TD>
                </TR>
            </xsl:for-each>

        </TABLE>

        <xsl:for-each select="ASFALIS:TranslationOptions">
            <xsl:call-template name="ASFALIS:PrintTranslationOptions"/>
        </xsl:for-each>

        <xsl:for-each select="ASFALIS:EntityNumberSets">
            <xsl:call-template name="ASFALIS:PrintEntityNumberSets"/>
        </xsl:for-each>
    </xsl:template>


    <!--
        Translation options
      -->
    <xsl:template name="ASFALIS:PrintTranslationOptions">
        <H4>変換オプション</H4>
        <TABLE border="1">
            <xsl:for-each select="ASFALIS:TranslationOption">
                <TR>
                    <TD><xsl:value-of select="@title"/></TD>
                    <TD><xsl:value-of select="@value"/></TD>
                </TR>
            </xsl:for-each>
        </TABLE>
    </xsl:template>


    <!--
        Environment variables
      -->
    <xsl:template name="ASFALIS:PrintEnvironmentVariables">
        <H4>環境変数</H4>
        <TABLE border="1">
            <xsl:for-each select="ASFALIS:EnvironmentVariable">
                <TR>
                    <TD><xsl:value-of select="@name"/></TD>
                    <TD><xsl:value-of select="@value"/></TD>
                </TR>
            </xsl:for-each>
        </TABLE>
    </xsl:template>


    <!--
        Entity numbers
      -->
    <xsl:template name="ASFALIS:PrintEntityNumberSets">
        <xsl:for-each select="ASFALIS:EntityNumberSet">
            <H4>要素数
                <xsl:choose>
                    <xsl:when test="@entityInfoType='Original'">(元データ)</xsl:when>
                    <xsl:when test="@entityInfoType='Target'">(変換結果)</xsl:when>
                    <xsl:when test="@entityInfoType='DEK'">(ENF)</xsl:when>
                </xsl:choose>
            </H4>
            <TABLE border="1">
                <xsl:for-each select="ASFALIS:EntityNumber">
                    <TR>
                        <TH><xsl:value-of select="@entityTitle"/></TH>
                        <TD><xsl:value-of select="@number"/></TD>
                    </TR>
                </xsl:for-each>
            </TABLE>
        </xsl:for-each>
    </xsl:template>


    <!--
        Mass properties
      -->
    <xsl:template name="ASFALIS:PrintMassProperties">
        <H4>物性値</H4>
        <TABLE border="1">
            <xsl:for-each select="ASFALIS:DekEntity">
                    <TR><TH>Volume ID</TH><TD><xsl:value-of select="@dekId"/>
                    <xsl:for-each select="@cadId">
                        ( <xsl:value-of select="."/> )
                    </xsl:for-each>
                    </TD></TR>
            </xsl:for-each>

            <xsl:for-each select="ASFALIS:MassProperty">
                <TR>
                    <TH>
                        <xsl:choose>
                            <xsl:when test="@massType='Volume'">体積</xsl:when>
                            <xsl:when test="@massType='SurfaceArea'">表面積</xsl:when>
                            <xsl:otherwise>その他</xsl:otherwise>
                        </xsl:choose>
                    </TH>

                    <TD><xsl:value-of select="@propertyValue"/></TD>

                    <TD>
                        <xsl:choose>
                            <xsl:when test="@entityInfoType='Original'">元データ</xsl:when>
                            <xsl:when test="@entityInfoType='DEK'">ENF</xsl:when>
                            <xsl:when test="@entityInfoType='Target'">変換結果</xsl:when>
                            <xsl:otherwise>その他</xsl:otherwise>
                        </xsl:choose>
                    </TD>
                </TR>
            </xsl:for-each>
        </TABLE>         
    </xsl:template>

    <xsl:template name="ASFALIS:PrintMassProperty">
    </xsl:template>


<!-- ########################### ASFALIS2006 ############################## -->
<!-- ###################################################################### -->
<!-- Root of this style sheet -->
    <xsl:template match="/ASFALIS2006:AsfalisLogList">
        <HTML>
        <HEAD>
            <TITLE>ASFALIS Adapter Log File</TITLE>
        </HEAD>

        <BODY>
        <H1>ASFALIS Adapter 実行ログ</H1>
        <xsl:for-each select="ASFALIS2006:AsfalisLog">
            <xsl:choose>
                <xsl:when test="@type='AUTOHEAL'"><H1>ENF Healer</H1></xsl:when>
                <xsl:when test="@type='CAD2ENF'"><H1>ENF Writer</H1></xsl:when>
                <xsl:when test="@type='ENF2CAD'"><H1>ENF Reader</H1></xsl:when>
                <xsl:when test="@type='PDQCHECK'"><H1>PDQ Checker</H1></xsl:when>
                <xsl:when test="@type='SIMPLIFY'"><H1>Geometry Simplifier</H1></xsl:when>
                <xsl:when test="@type='GEOMDIFF'"><H1>CAD Validator</H1></xsl:when>
                <xsl:when test="@type='ATTREDIT'"><H1>Attribute Editor</H1></xsl:when>
                <xsl:when test="@type='QFMCHECK'"><H1>QFM Checker</H1></xsl:when>
                <xsl:when test="@type='PLYGNOPTIMIZE'"><H1>Polygon Optimizer</H1></xsl:when>
                <xsl:when test="@type='POLYGON'"><H1>ENF Polygon</H1></xsl:when>
                <xsl:otherwise><H1>ASFALIS Adapter Family</H1></xsl:otherwise>
            </xsl:choose>

            <xsl:if test="@isPrimary='no'">
                (補助情報)
            </xsl:if>

            <xsl:apply-templates select="ASFALIS2006:ProcessInfo"/>
            <xsl:apply-templates select="ASFALIS2006:ModelInfoList"/>
            <xsl:apply-templates select="ASFALIS2006:AssemblyTreeInfo"/>
            <xsl:apply-templates select="ASFALIS2006:BodyInfoList"/>
            <xsl:apply-templates select="ASFALIS2006:ComponentInfoList"/>
            <xsl:call-template name="ASFALIS2006:PrintGeometryValidation"/>
            <HR/>
        </xsl:for-each>
        </BODY>
        </HTML>
    </xsl:template>



<!-- ###################################################################### -->

<!--
    Print information of overall process
  -->
    <xsl:template match="ASFALIS2006:ProcessInfo">
        <H2>概要</H2>
        <TABLE border="1">
            <TR>
                <TH>変換元</TH>
                <TD><xsl:value-of select="ASFALIS2006:OriginalCad/@name"/></TD>
                <TD><xsl:value-of select="ASFALIS2006:OriginalCad/@version"/></TD>
            </TR>
            <TR>
                <TH>変換先</TH>
                <TD><xsl:value-of select="ASFALIS2006:TargetCad/@name"/></TD>
                <TD><xsl:value-of select="ASFALIS2006:TargetCad/@version"/></TD>
            </TR>
            <TR>
                <TH>入力ファイル名</TH>
                <TD><xsl:value-of select="ASFALIS2006:InputFile/@fileName"/></TD>
                <TD><xsl:value-of select="ASFALIS2006:InputFile/@version"/></TD>
            </TR>
            <TR>
                <TH>出力ファイル名</TH>
                <TD><xsl:value-of select="ASFALIS2006:OutputFile/@fileName"/></TD>
                <TD><xsl:value-of select="ASFALIS2006:OutputFile/@version"/></TD>
            </TR>
            <TR>
                <TH>開始時刻</TH>
                <TD colspan="2"><xsl:value-of select="ASFALIS2006:TimeInfo/@startTime"/></TD>
            </TR>
            <TR>
                <TH>終了時刻</TH>
                <TD colspan="2"><xsl:value-of select="ASFALIS2006:TimeInfo/@endTime"/></TD>
            </TR>
            <TR>
                <TH>所要時間</TH>
                <TD colspan="2"><xsl:value-of select="ASFALIS2006:TimeInfo/@duration"/></TD>
            </TR>
            <TR>
                <TH>プログラム</TH>
                <TD><xsl:value-of select="ASFALIS2006:ElysiumModule/@fileName"/></TD>
                <TD><xsl:value-of select="ASFALIS2006:ElysiumModule/@version"/></TD>
            </TR>
        </TABLE>

        <xsl:apply-templates select="ASFALIS2006:Errors"/>
        <xsl:call-template name="ASFALIS2006:ProcessDetailInfo"/>
    </xsl:template>

<!-- ###################################################################### -->
<!--
    Print information of model, (occurrence tree)
  -->
    <xsl:template match="ASFALIS2006:ModelInfoList">
        <HR/>
        <H2>アセンブリツリー</H2>
            <xsl:for-each select="ASFALIS2006:ModelInfo">
                <xsl:call-template name="ASFALIS2006:PrintModelInfo"/>
                <HR/>
            </xsl:for-each>
    </xsl:template>

    <xsl:template name="ASFALIS2006:PrintModelInfo">
        <xsl:for-each select="ASFALIS2006:ComponentRef">
            <xsl:call-template name="ASFALIS2006:PrintComponentRef"/>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="ASFALIS2006:PrintComponentRef">
        <xsl:for-each select="@dekId">
            [ID : <xsl:value-of select="."/>]  
        </xsl:for-each>
        <UL>
        <xsl:for-each select="ASFALIS2006:ComponentInstanceInfo">
            <LI><xsl:call-template name="ASFALIS2006:PrintComponentInstanceInfo"/></LI>
        </xsl:for-each>
        </UL>
    </xsl:template>

    <xsl:template name="ASFALIS2006:PrintComponentInstanceInfo">
        <xsl:for-each select="@instanceName">
            [<xsl:value-of select="."/>]  
        </xsl:for-each>
        <xsl:for-each select="ASFALIS2006:ComponentRef">
            <xsl:call-template name="ASFALIS2006:PrintComponentRef"/>
        </xsl:for-each>
     </xsl:template>


<!-- ###################################################################### -->
<!--
    Print information of assembly tree
  -->
    <xsl:template match="ASFALIS2006:AssemblyTreeInfo">
        <HR/>
        <H2>アセンブリツリー</H2>
        <UL>
        <xsl:for-each select="ASFALIS2006:AssemblyInfo">
            <LI><xsl:call-template name="ASFALIS2006:PrintAssemblyInfo"/></LI>
        </xsl:for-each>
        <xsl:for-each select="ASFALIS2006:BodyRef">
            <LI><xsl:call-template name="ASFALIS2006:PrintBodyRefInfo"/></LI>
        </xsl:for-each>
        </UL>
    </xsl:template>

<!--
    Print information of assembly
  -->
    <xsl:template name="ASFALIS2006:PrintAssemblyInfo">
        A  
        <xsl:for-each select="@assemblyName">
            [<xsl:value-of select="."/>]  
        </xsl:for-each>

        <xsl:for-each select="@assemblyDekId">
            [ID : <xsl:value-of select="."/>]  
        </xsl:for-each>

        <xsl:for-each select="@assemblyPartNumber">
            [Part Number = <xsl:value-of select="."/>]
        </xsl:for-each>
        <BR/>
        <UL>
            <xsl:for-each select="ASFALIS2006:InstanceInfo">
                <LI>
                    <xsl:call-template name="ASFALIS2006:PrintInstanceInfo"/>
                </LI>
            </xsl:for-each>
        </UL>
    </xsl:template>


<!--
    Print information of assembly instance
  -->
    <xsl:template name="ASFALIS2006:PrintInstanceInfo">
        I   
        <xsl:for-each select="@instanceName">
            [<xsl:value-of select="."/>]  
        </xsl:for-each>
        <xsl:for-each select="@instanceDekId">
            [ID : <xsl:value-of select="."/>]  
        </xsl:for-each>
        <BR/>
        <UL>
        <xsl:for-each select="ASFALIS2006:AssemblyInfo">
            <LI><xsl:call-template name="ASFALIS2006:PrintAssemblyInfo"/></LI>
        </xsl:for-each>
        <xsl:for-each select="ASFALIS2006:BodyRef">
            <LI><xsl:call-template name="ASFALIS2006:PrintBodyRefInfo"/></LI>
        </xsl:for-each>
        </UL>
     </xsl:template>


<!--
    Print information of body reference from assembly tree
  -->
    <xsl:template name="ASFALIS2006:PrintBodyRefInfo">
        B 
        <xsl:for-each select="@bodyName">
            [<xsl:value-of select="."/>]  
        </xsl:for-each>

        <xsl:for-each select="@bodyDekId">
            [ID : <xsl:value-of select="."/>]  
        </xsl:for-each>
    </xsl:template>


<!-- ###################################################################### -->
<!--
    Print information of each component
  -->
    <xsl:template match="ASFALIS2006:ComponentInfoList">
        <HR/>
        <H2>各Part,Assemblyの情報</H2>
            <xsl:for-each select="ASFALIS2006:ComponentInfo">
                <xsl:call-template name="ASFALIS2006:PrintComponentInfo"/>
                <HR/>
            </xsl:for-each>
    </xsl:template>

    <xsl:template name="ASFALIS2006:PrintComponentInfo">
        <TABLE border="1">
            <xsl:for-each select="@dekId">
                <TR>
                    <TH>Part ID (ENF)</TH><TH><xsl:value-of select="."/></TH>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@componentType">
                <TR>
                    <TH>Type</TH><TH><xsl:value-of select="."/></TH>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@componentName">
                <TR>
                    <TH>名前</TH><TH><xsl:value-of select="."/></TH>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@partName">
                <TR>
                    <TH>Part Name</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@partNumber">
                <TR>
                    <TH>Part Number</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>
            
            <xsl:for-each select="@nativeFilename">
                <TR>
                    <TH>元CADファイル名</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>

        </TABLE>

        <xsl:for-each select="ASFALIS2006:Representation">
            <xsl:call-template name="ASFALIS2006:PrintRepresentation"/>
        </xsl:for-each>
        
    </xsl:template>


    <xsl:template name="ASFALIS2006:PrintRepresentation">
        <xsl:for-each select="ASFALIS2006:Errors">
            <xsl:call-template name="ASFALIS2006:PrintErrors"/>
        </xsl:for-each>

        <xsl:for-each select="ASFALIS2006:MassProperties">
            <xsl:call-template name="ASFALIS2006:PrintMassProperties"/>
        </xsl:for-each>

        <xsl:for-each select="ASFALIS2006:EntityNumberSets">
            <xsl:call-template name="ASFALIS2006:PrintEntityNumberSets"/>
        </xsl:for-each>
    </xsl:template>

<!--
    Print information of each body
  -->
    <xsl:template match="ASFALIS2006:BodyInfoList">
        <HR/>
        <H2>各Partの情報</H2>
            <xsl:for-each select="ASFALIS2006:BodyInfo">
                <xsl:call-template name="ASFALIS2006:PrintBodyInfo"/>
                <HR/>
            </xsl:for-each>
    </xsl:template>

    <xsl:template name="ASFALIS2006:PrintBodyInfo">
        <TABLE border="1">
            <xsl:for-each select="@bodyDekId">
                <TR>
                    <TH>Part ID (ENF)</TH><TH><xsl:value-of select="."/></TH>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@bodyName">
                <TR>
                    <TH>名前</TH><TH><xsl:value-of select="."/></TH>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@partName">
                <TR>
                    <TH>Part Name</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@partNumber">
                <TR>
                    <TH>Part Number</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="@nativeFilename">
                <TR>
                    <TH>元CADファイル名</TH><TD><xsl:value-of select="."/></TD>
                </TR>
            </xsl:for-each>
        </TABLE>

        <xsl:for-each select="ASFALIS2006:Errors">
            <xsl:call-template name="ASFALIS2006:PrintErrors"/>
        </xsl:for-each>

        <xsl:for-each select="ASFALIS2006:MassProperties">
            <xsl:call-template name="ASFALIS2006:PrintMassProperties"/>
        </xsl:for-each>

        <xsl:for-each select="ASFALIS2006:EntityNumberSets">
            <xsl:call-template name="ASFALIS2006:PrintEntityNumberSets"/>
        </xsl:for-each>
    </xsl:template>


<!-- ###################################################################### -->
    <!--
        Print error information
      -->
    <xsl:template match="ASFALIS2006:Errors">
        <xsl:call-template name="ASFALIS2006:PrintErrors"/>
    </xsl:template>

    <xsl:template name="ASFALIS2006:PrintErrors">
        <H4><FONT color="#FF0000">変換エラー</FONT></H4>
        <TABLE border="1">
            <TR>
                <TH>エラータイプ</TH>
                <TH>説明</TH>
            </TR>
            <xsl:for-each select="ASFALIS2006:Error">
                <TR>
                    <TD><xsl:value-of select="@errorType"/></TD>
                    <TD><xsl:value-of select="@description"/></TD>
                </TR>
            </xsl:for-each>
        </TABLE>
    </xsl:template>


    <!--
        Print detail information usefull for developers
      -->
    <xsl:template name="ASFALIS2006:ProcessDetailInfo">
        <HR/>
        <H2>詳細情報</H2>
        <TABLE border="1">
            <xsl:for-each select="ASFALIS2006:OS">
                <TR>
                    <TH>OS</TH>
                    <TD><xsl:value-of select="@name"/></TD>
                    <TD><xsl:value-of select="@version"/></TD>
                </TR>
            </xsl:for-each>

            <xsl:for-each select="ASFALIS2006:CurrentDirectory">
                <TR>
                    <TH>実行ディレクトリ</TH>
                    <TD><xsl:value-of select="@pathName"/></TD>
                </TR>
            </xsl:for-each>

        </TABLE>

        <xsl:for-each select="ASFALIS2006:TranslationOptions">
            <xsl:call-template name="ASFALIS2006:PrintTranslationOptions"/>
        </xsl:for-each>

        <xsl:for-each select="ASFALIS2006:EntityNumberSets">
            <xsl:call-template name="ASFALIS2006:PrintEntityNumberSets"/>
        </xsl:for-each>
    </xsl:template>


    <!--
        Translation options
      -->
    <xsl:template name="ASFALIS2006:PrintTranslationOptions">
        <H4>変換オプション</H4>
        <TABLE border="1">
            <xsl:for-each select="ASFALIS2006:TranslationOption">
                <TR>
                    <TD><xsl:value-of select="@title"/></TD>
                    <TD><xsl:value-of select="@value"/></TD>
                </TR>
            </xsl:for-each>
        </TABLE>
    </xsl:template>


    <!--
        Environment variables
      -->
    <xsl:template name="ASFALIS2006:PrintEnvironmentVariables">
        <H4>環境変数</H4>
        <TABLE border="1">
            <xsl:for-each select="ASFALIS2006:EnvironmentVariable">
                <TR>
                    <TD><xsl:value-of select="@name"/></TD>
                    <TD><xsl:value-of select="@value"/></TD>
                </TR>
            </xsl:for-each>
        </TABLE>
    </xsl:template>


    <!--
        Entity numbers
      -->
    <xsl:template name="ASFALIS2006:PrintEntityNumberSets">
        <xsl:for-each select="ASFALIS2006:EntityNumberSet">
            <H4>要素数
                <xsl:choose>
                    <xsl:when test="@entityInfoType='Original'">(元データ)</xsl:when>
                    <xsl:when test="@entityInfoType='Target'">(変換結果)</xsl:when>
                    <xsl:when test="@entityInfoType='DEK'">(ENF)</xsl:when>
                </xsl:choose>
            </H4>
            <TABLE border="1">
                <xsl:for-each select="ASFALIS2006:EntityNumber">
                    <TR>
                        <TH><xsl:value-of select="@entityTitle"/></TH>
                        <TD><xsl:value-of select="@number"/></TD>
                    </TR>
                </xsl:for-each>
            </TABLE>
        </xsl:for-each>
    </xsl:template>


    <!--
        Mass properties
      -->
    <xsl:template name="ASFALIS2006:PrintMassProperties">
        <H4>物性値</H4>
        <TABLE border="1">
            <xsl:for-each select="ASFALIS2006:DekEntity">
                    <TR><TH>Volume ID</TH><TD><xsl:value-of select="@dekId"/>
                    <xsl:for-each select="@cadId">
                        ( <xsl:value-of select="."/> )
                    </xsl:for-each>
                    </TD></TR>
            </xsl:for-each>

            <xsl:for-each select="ASFALIS2006:MassProperty">
                <TR>
                    <TH>
                        <xsl:choose>
                            <xsl:when test="@massType='Volume'">体積</xsl:when>
                            <xsl:when test="@massType='SurfaceArea'">表面積</xsl:when>
                            <xsl:when test="@massType='GravityPoint'">重心</xsl:when>
                            <xsl:otherwise>その他</xsl:otherwise>
                        </xsl:choose>
                    </TH>

                    <TD><xsl:value-of select="@propertyValue"/></TD>

                    <TD>
                        <xsl:choose>
                            <xsl:when test="@entityInfoType='Original'">元データ</xsl:when>
                            <xsl:when test="@entityInfoType='DEK'">ENF</xsl:when>
                            <xsl:when test="@entityInfoType='Target'">変換結果</xsl:when>
                            <xsl:otherwise>その他</xsl:otherwise>
                        </xsl:choose>
                    </TD>
                </TR>
            </xsl:for-each>
        </TABLE>         
    </xsl:template>

  

   <xsl:template name="ASFALIS2006:PrintGeometryValidation">
     <xsl:for-each select="ASFALIS2006:CompareOptions">
       <H2>形状比較結果</H2>
         <xsl:call-template name="ASFALIS2006:PrintCompareOptions"/>
     </xsl:for-each>

     <xsl:for-each select="ASFALIS2006:CompareResultSummary">
         <xsl:call-template name="ASFALIS2006:PrintCompareResultSummary"/>
     </xsl:for-each>
    
   </xsl:template>

   <xsl:template name="ASFALIS2006:PrintCompareOptions">
    <H4>比較オプション</H4>
      <TABLE border="1">
        <xsl:for-each select="ASFALIS2006:CompareOption">
           <TR>
             <TD><xsl:value-of select="@title"/></TD>
             <TD><xsl:value-of select="@value"/></TD>
           </TR>
        </xsl:for-each>
      </TABLE>
   </xsl:template>

   <xsl:template name="ASFALIS2006:PrintCompareResultSummary">
    <H4>比較結果</H4>
    <TABLE border="1">      
      <xsl:for-each select="ASFALIS2006:CompareResultSummary">
           <TR>
             <TD><xsl:value-of select="@title"/></TD>
             <TD><xsl:value-of select="@value"/></TD>
           </TR>
        </xsl:for-each>
    </TABLE>
   </xsl:template>
   
</xsl:stylesheet>

