# -*- encoding: UTF-8 -*-
module PdfEditor
  class CustomizedEnfPreProcess
    logger.info "Custom File (#{__FILE__}): "

    def on_run_before(ee_session)
      ee_session.model.components.each do |compo|
        # Create mapping from BoC ID to referenced PMI
        id_to_ref = Hash.new
        compo.annotations.each do |anno|
          md = anno.name.match(/EREF\(([\d;]+)\)/)
          next if md.nil? || md.size != 2
          md[1].split(";").each do |id|
            id_to_ref[id] = anno
          end
        end

        # Flag BoC and set referenced PMI
        compo.annotations.each do |anno|
          md = anno.name.match(/EBOC(\d+)/)
          next if md.nil? || md.size != 2
          ref_anno = id_to_ref[md[1]]
          next if ref_anno.nil?
          anno.boc_tag = true
          anno.boc_ref = ref_anno
        end
      end
    end

  end
end
